/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4-BIT PARALLEL ACCESS SHIFT REGISTERS 
TRUTHTABLE     : 
------------------------------------------------------------------------
   CLR_    SH_LD_    CLK    J  K_    A  B  C  D     QA  QB  QC  QD  QD_
------------------------------------------------------------------------
    L        X        X     X  X     X  X  X  X     L   L   L   L   H
                       _
    H        L       _/     X  X     A  B  C  D     A   B   C   D   D_ 

    H        H        L     X  X     X  X  X  X     QA  QB  QC  QD  QD_
                       _
    H        H       _/     L  H     X  X  X  X     QA  QA  QB  QC  QC_
                       _
    H        H       _/     L  L     X  X  X  X     L   QA  QB  QC  QC_
                       _
    H        H       _/     H  H     X  X  X  X     H   QA  QB  QC  QC_
                       _
    H        H       _/     H  H     X  X  X  X     QA _QA  QB  QC  QC_
------------------------------------------------------------------------

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a195 (clrn, j, kn, a, b, c, d, shld, clk, qdn, qd, qc, qb, qa);
	parameter size =1;
	input
		clrn,
		j,
		kn,
		a,
		b,
		c,
		d,
		shld,
		clk;
	output
		qdn,
		qd,
		qc,
		qb,
		qa;
    reg
        NOTIFY_REG;
    not
	N1 (ld, shld);
    and
	A1 (shift, clrn, shld);
    and
	A2 (load, clrn, ld);
    not
	M195_inst_I1 (m195_inst_mode_, shld);
    not
	M195_inst_I2 (m195_inst_mode, m195_inst_mode_);
    and
	M195_inst_A1 (m195_inst_sa1, m195_inst_qa_, m195_inst_mode, j);
    and
	M195_inst_A2 (m195_inst_sa2, m195_inst_qaint, m195_inst_mode, kn);
    and
	M195_inst_A3 (m195_inst_pa, m195_inst_mode_, a);
    or
	M195_inst_N1 (m195_inst_sr_a, m195_inst_sa1, m195_inst_sa2, m195_inst_pa);
    buf
	  (qa, m195_inst_qaint);
    buf
	  (qb, m195_inst_qbint);
    buf
	  (qc, m195_inst_qcint);
    buf
	  (qd, m195_inst_qdint);
    not
	  (m195_inst_qa_, m195_inst_qaint);
    not
	  (qdn, m195_inst_qdint);
    U_AO_2_2
	M195_inst_inst1_inst1 (m195_inst_sr_d, m195_inst_mode, m195_inst_qcint, m195_inst_mode_, d);
    U_AO_2_2
	M195_inst_inst2_inst1 (m195_inst_sr_c, m195_inst_mode, m195_inst_qbint, m195_inst_mode_, c);
    U_AO_2_2
	M195_inst_inst3_inst1 (m195_inst_sr_b, m195_inst_mode, m195_inst_qaint, m195_inst_mode_, b);
    U_FD_P_RB_NO  
	M195_inst_DFF1_inst1 (m195_inst_qaint, m195_inst_sr_a, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M195_inst_DFF2_inst1 (m195_inst_qbint, m195_inst_sr_b, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M195_inst_DFF3_inst1 (m195_inst_qcint, m195_inst_sr_c, clk, clrn, NOTIFY_REG);
    U_FD_P_RB_NO  
	M195_inst_DFF4_inst1 (m195_inst_qdint, m195_inst_sr_d, clk, clrn, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
